﻿<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">







<xsl:template match="description">
   <SPAN CLASS="description"><xsl:apply-templates/></SPAN>
</xsl:template>



<xsl:template match="description/br">
   <BR/>
</xsl:template>

<xsl:template match="task">
  <FONT color="black"  >

 <xsl:apply-templates/></FONT>
</xsl:template>




<xsl:template match="phonem">
 <SPAN CLASS="phonem"><xsl:value-of select="."/></SPAN>
</xsl:template>

















<xsl:template match="//link">
 <A  onFocus="this.blur()" href="#_text={@target}"><xsl:apply-templates/></A>
</xsl:template>

<xsl:template match="//tr">
 <TR><xsl:apply-templates/></TR>
</xsl:template>

<xsl:template match="//td">
 <TD width="{@width}"><xsl:apply-templates/></TD>
</xsl:template>

<xsl:template match="//unit/theory/part/table">
  <TR>
<xsl:if test="image">
 <TD align="center">
 <IMG src="pic/{image}" border="0"/>
  
</TD>
<TD>
<TABLE width="100%" border="0">
<xsl:apply-templates/>
</TABLE>
</TD>
</xsl:if>
<xsl:if test="not(image)">
 
<TD colspan="2">
<TABLE width="100%" border="1">
<xsl:apply-templates/>
</TABLE>
</TD>
</xsl:if>
</TR>
</xsl:template>

<xsl:template match="//string">
 <SPAN style="font-size:large;font-weight:900">- </SPAN><xsl:apply-templates/><BR/>
</xsl:template>

<xsl:template match="//li">
 <LI><A onFocus="this.blur()" href="#_text={@target}"><xsl:apply-templates/></A></LI>
</xsl:template>

<xsl:template match="//string_simple">
<xsl:apply-templates/><BR/>
</xsl:template>

<xsl:template match="//unit/theory/part/first">
 <TR><TD align="justify" colspan="2"><DIV align="justify"><SPAN style="text-align:justify;  text-indent: 10px;"><xsl:apply-templates/></SPAN></DIV></TD></TR> 
</xsl:template>

<xsl:template match="//unit/theory/part/example_multi">
  <TR>
<xsl:if test="image">
 <TD align="center">
 <IMG src="pic/{image}" border="0"/>
  
</TD>
<TD>
<DIV align="justify">
<xsl:apply-templates/>
</DIV>
</TD>
</xsl:if>
<xsl:if test="not(image)">
 
<TD colspan="2">
<DIV align="justify">
<xsl:apply-templates/>
</DIV>
</TD>
</xsl:if>
</TR>
</xsl:template>

<xsl:template match="//unit/theory/part/example_simple">
 <TR>
<xsl:if test="image">
 <TD align="center">
 <IMG src="pic/{image}" border="0"/>
  
</TD>
<TD>
<DIV align="justify">
<xsl:apply-templates/>
</DIV>
</TD>
</xsl:if>
<xsl:if test="not(image)">
 
<TD colspan="2">
<DIV align="justify">
<xsl:apply-templates/>
</DIV>
</TD>
</xsl:if>
</TR>

</xsl:template>

<xsl:template match="txt_z_n">
 <SPAN CLASS="txt_z_n"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="txt_m_i">
 <SPAN CLASS="txt_m_i"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="txt_m_n">
 <SPAN CLASS="txt_m_n"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="txt_m_b">
 <SPAN CLASS="txt_m_b"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="txt_b_b">
 <SPAN CLASS="txt_b_b"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="txt_b_n">
 <SPAN CLASS="txt_b_n"><xsl:value-of select="."/></SPAN>
</xsl:template>
<xsl:template match="txt_b_i">
 <SPAN CLASS="txt_b_i"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="//h2">
 <H2><center><xsl:apply-templates/></center></H2>
</xsl:template>

<xsl:template match="//maroon">
 <SPAN class="4"><xsl:apply-templates/></SPAN> 
</xsl:template>

<xsl:template match="//tense">
 <SPAN class="4"><xsl:apply-templates/></SPAN> 
</xsl:template>



<xsl:template match="//bold">
 <SPAN class="3"><FONT size="{@size}"><xsl:apply-templates/></FONT></SPAN> 
</xsl:template>

<xsl:template match="//unit/theory/part/ol">
 <TR><TD align="justify" colspan="2"><OL type="I"><xsl:apply-templates/></OL></TD></TR> 
</xsl:template>

<xsl:template match="//img">
<TR><TD align="center" colspan="2"><IMG src="pic/{@name}"/></TD></TR> 
</xsl:template>

<xsl:template match="//text()">
<SPAN style="font-family: Arial; text-align:justify"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="//unit/theory/part/bukvi">
 <TR><TD align="center" colspan="2"><xsl:apply-templates/></TD></TR> 
</xsl:template>


<xsl:template match="//unit/theory/part/para">
 <TR><TD align="justify" colspan="2"><DIV align="justify"><xsl:apply-templates/></DIV></TD></TR> 
</xsl:template>



<xsl:template match="//unit/theory/part/para[1]">
 <TR><TD align="justify" colspan="2">
 <DIV align="justify"><SPAN style="font-family: Arial;font-weight:bold; text-align:justify"><xsl:number level="single"  format="a" count="//theory/part"/>) </SPAN>
 <xsl:apply-templates/></DIV></TD></TR> 
</xsl:template>


<xsl:template match="//unit/theory/part/example">
 <TR>
<xsl:if test="image">
 <TD align="center">
 <IMG src="pic/{image}" border="0"/>
  
</TD>
<TD>
<DIV align="justify"><SPAN style="font-size:large;font-weight:900; text-align: justify;">- </SPAN><xsl:apply-templates/></DIV>
</TD>
</xsl:if>
<xsl:if test="not(image)">
 
<TD colspan="2">
<DIV align="justify"><SPAN style="font-size:large;font-weight:900">- </SPAN><xsl:apply-templates/></DIV>
</TD>
</xsl:if>
</TR>

</xsl:template>

<xsl:template match="//image"/>

<xsl:template name="unit_number">
<xsl:param name="CurrentPage" select="/page[@num=1]"/>


<xsl:for-each select="$CurrentPage/unit">
<font color="blue" style="margin-right:10px;"><B>Unit <xsl:value-of select="@number"/> </B></font>
</xsl:for-each>
</xsl:template>



<xsl:template match="//page/block/string">
|&#160;<a href="#_ins=E{@num}|{@content}%20" hideFocus="true"><FONT style="font-weight:bold;"><xsl:value-of select="@content"/></FONT>&#160;</a>&#160;|
</xsl:template>












<xsl:template name="img">
<TR><TD align="center" colspan="2"><IMG src="../pic/{/topic/page/unit/image}.gif"/><BR/></TD></TR> 
</xsl:template>

<xsl:template match="//br">
<BR/>
</xsl:template>

<xsl:template match="//page/block/main/gap">
<input type="text" name="E{@num}" size="{@size}" id="E{@num}" value="{@value}" class="gap"/>
</xsl:template>

<xsl:template match="//page/block/main/gap_paste">
<input type="text" name="E{@num}" size="{@size}" id="E{@num}" value="{@value}" class="gap" onclick="paste_word(this);"/>
</xsl:template>

<xsl:template match="//page/block/main/gap_paste_multi">
<input type="text" name="E{@num}" size="{@size}" id="E{@num}" value="{@value}" class="gap" onclick="paste_word_multi(this);"/>
</xsl:template>

<xsl:template match="//page/block/link/string">
|&#160;<a href="#_ins=E{@num}|{@content}%20" hideFocus="true"><FONT style="font-weight: bold;"><xsl:value-of select="@content"/></FONT>&#160;</a>&#160;|
</xsl:template>

<xsl:template match="//page/block/link">
<TR  align="center"><TD colspan="3"><xsl:apply-templates/></TD></TR>
</xsl:template>

<xsl:template match="//page/block/main/sentence">
<FONT color="black"><B><xsl:apply-templates/></B></FONT>
</xsl:template>



<xsl:template match="//plus">
<IMG src="../../../pic/plus.gif" border="0"/>
</xsl:template>

<xsl:template match="//minus">
<IMG src="../../../pic/minus.gif" border="0"/>
</xsl:template>

<xsl:template match="//vopros">
<IMG src="../../../pic/vopros.gif" border="0"/>
</xsl:template>


<xsl:template match="//page/block/main">
<TR align="center">
<xsl:if test="play">
<TD>
<A href="#_sb={//page/block/main/play/@file}" onFocus="this.blur()">
<IMG src="../../../pic/dinamic_off1.gif" border="0" />
</A>
</TD>
</xsl:if>
<TD  align="left"  width="90%"><xsl:apply-templates/>
</TD>
<TD width="58px" valign="bottom">
<xsl:if test="//topic/page/multi">
<input type="image" src="../../../pic/OK.gif" name="B{@num}" id="B{@num}" onclick="self.navigate('#_click1=B{@num}')" hideFocus="true" onmouseover="this.src='../../../pic/OK_over.gif'" onmouseout="this.src='../../../pic/OK.gif'" onmousedown="this.src='../../../pic/OK_down.gif'" onmouseup="this.src='../../../pic/OK_over.gif'"/>  
</xsl:if>
<xsl:if test="not(//topic/page/multi)">
<input type="image" src="../../../pic/OK.gif" name="B{@num}" id="B{@num}" onclick="self.navigate('#_click=B{@num}')" hideFocus="true" onmouseover="this.src='../../../pic/OK_over.gif'" onmouseout="this.src='../../../pic/OK.gif'" onmousedown="this.src='../../../pic/OK_down.gif'" onmouseup="this.src='../../../pic/OK_over.gif'"/>  
</xsl:if>
<input src="../../../pic/BDGRAY.GIF" name="I{@num}" id="I{@num}" type="image" width="22" height="21" hideFocus="true" style="cursor: default;"/></TD>
</TR>
</xsl:template>

<xsl:template match="//page/example/ex/gap">
<input type="text" size="{@size}" value="{@value}" class="gap"/>
</xsl:template>

<xsl:template match="//page/example/ex/sentence">
<FONT color="maroon"><B><xsl:apply-templates/></B></FONT>
</xsl:template>

<xsl:template match="//page/example/sentence">
<TR><TD align="center"><FONT color="maroon"><B><xsl:apply-templates/></B></FONT></TD></TR>
</xsl:template>

<xsl:template match="//unit/example/ex/sentence/plus">
<IMG src="../../../pic/plus_ex.gif" border="0"/>
</xsl:template>

<xsl:template match="//page/example/ex/sentence/minus">
<IMG src="../../../pic/minus_ex.gif" border="0"/>
</xsl:template>

<xsl:template match="//page/example/ex/sentence/vopros">
<IMG src="../../../pic/vopros_ex.gif" border="0"/>
</xsl:template>


<xsl:template match="//page/example/ex">
 <TR><TD align="left" ><xsl:apply-templates/></TD></TR> 
</xsl:template>







<xsl:template name="ChooseWord">
 <xsl:param name="CurrPageNum" select="@num"/>
	<TABLE  width="100%"  cellpadding="0" cellspacing="5" border="0">


      <xsl:for-each select="//topic/page[@num=$CurrPageNum]/examples/words">
<TR>
<TD>
<TABLE  width="100%"  cellpadding="0" cellspacing="0" border="0" class="border_aud">
<TR>
<TD><IMG src="../../../pic/dinamic_off1.gif"  onMouseOver="this.src='../../../pic/dinamic_over.gif'" onMouseOut="this.src='../../../pic/dinamic_off1.gif'" border="0" space="1px"  id="{@id}_1" onclick="navigate('#_playAEx1={@id}'), Dinamic_click('{@id}_1');"/></TD>

<TD width="100%" style="padding:2px;"><xsl:apply-templates select="word"/></TD>
<TD style="padding:4px;"><IMG src="../../../pic/marker_off.gif" id="{@id}" border="0"/></TD>
</TR>	
</TABLE> 
</TD>
</TR>    
                        
     </xsl:for-each>


</TABLE> 
</xsl:template>

<xsl:template match="//word">
&#160;
<A href="#_clickAEx1=id_word_{@id}" onFocus="this.blur()" n="examples_choose"  id="id_word_{@id}" class="examples_choose" onclick="ClickExample(this, ' ', 'choose')" >
<SPAN  >

<xsl:value-of select="@spelling"/>

</SPAN>
</A>
&#160;
</xsl:template>

<xsl:template name="ChooseCorrPhrase">
 <xsl:param name="CurrPageNum" select="@num"/>

<TABLE  width="100%"   cellpadding="0" cellspacing="3" border="0">
<xsl:for-each select="//topic/page[@num=$CurrPageNum]/phrases_choose/words">
<TR>
<TD class="border_aud">
	<TABLE  width="100%"  cellpadding="0" cellspacing="0" border="0" style="padding:2px;">
      
<TR>

<TD width="50%"><xsl:value-of select="@value"/></TD>
<TD ><xsl:apply-templates/></TD>
<TD width="30px" ><IMG src="../../../pic/marker_off.gif" id="{@id}" border="0"/></TD>
</TR>	     
         </TABLE>

</TD>   
</TR>            
     </xsl:for-each>

</TABLE> 
</xsl:template>




<xsl:template match="//page/phrases_choose/words/phrase">
<A href="#_clickCEx1={@test_id}|id_word_{@id}" onFocus="this.blur()"  n="examples"  id="id_word_{@id}" class="examples" onclick="ClickExample(this, '{@name}', 'choose')" ><xsl:value-of select="@spelling"/></A><xsl:text> </xsl:text>
</xsl:template>

<xsl:template match="//br">
<BR/>
</xsl:template>

<xsl:template name="ChooseWord_Table">
 <xsl:param name="CurrPageNum" select="@num"/>
	<TABLE  width="100%"  cellpadding="0" cellspacing="5" border="0">

      <xsl:for-each select="//topic/page[@num=$CurrPageNum]/examples/word_table">
<TR>
<TD >
<TABLE  width="100%"  cellpadding="2" cellspacing="0" border="0" class="border_aud">
<TR >
<TD width="100%"><SPAN class="examples" ><xsl:value-of select="@spelling"/></SPAN><xsl:text> </xsl:text></TD>
<xsl:if test="(//topic/page[@num=$CurrPageNum]/button_choose/@kolvo)='2'">
<TD width="50px"><IMG src="../../../pic/but_1__off.gif" onmouseover="this.src='../../../pic/but_1_over.gif'" onmouseout="this.src='../../../pic/but_1__off.gif'" border="0"  id="L_{@test_id}" onclick="navigate('#_clickBEx1={@test_id}|L_{@id}|L1')"/></TD>
<TD width="50px"><IMG src="../../../pic/but_2__off.gif" onmouseover="this.src='../../../pic/but_2_over.gif'" onmouseout="this.src='../../../pic/but_2__off.gif'" border="0"  id="R_{@test_id}" onclick="navigate('#_clickBEx1={@test_id}|R_{@id}|R1')"/></TD>
</xsl:if>
<xsl:if test="(//topic/page[@num=$CurrPageNum]/button_choose/@kolvo)='3'">
<TD width="50px"><IMG src="../../../pic/but_1__off.gif" onmouseover="this.src='../../../pic/but_1_over.gif'" onmouseout="this.src='../../../pic/but_1__off.gif'" border="0"  id="L_{@test_id}" onclick="navigate('#_clickBEx1={@test_id}|L_{@id}|L1')"/></TD>
<TD width="50px"><IMG src="../../../pic/but_2__off.gif" onmouseover="this.src='../../../pic/but_2_over.gif'" onmouseout="this.src='../../../pic/but_2__off.gif'" border="0"  id="M_{@test_id}" onclick="navigate('#_clickBEx1={@test_id}|M_{@id}|M1')"/></TD>
<TD width="50px"><IMG src="../../../pic/but_3__off.gif" onmouseover="this.src='../../../pic/but_3_over.gif'" onmouseout="this.src='../../../pic/but_3__off.gif'" border="0"  id="R_{@test_id}" onclick="navigate('#_clickBEx1={@test_id}|R_{@id}|R1')"/></TD>

</xsl:if>
</TR>	     
              </TABLE>       
</TD>
</TR>   
     </xsl:for-each>

</TABLE> 
</xsl:template>




<xsl:template match="//topic/page/examp/table">
 <TR><TD><TABLE width="100%" border="1" style="font-size:12pt; font-weight:bold;"><xsl:apply-templates/></TABLE></TD></TR>
<TR><TD height="10px"></TD></TR>
</xsl:template>

<xsl:template match="//topic/page/examp/table/tr/td">
 <TD align="justify" width="{@width}" colspan="{@colspan}" rowspan="{@rowspan}"><DIV align="justify" style="text-indent: 10px;width:99%;"><xsl:apply-templates/></DIV></TD> 
</xsl:template>

<xsl:template match="//topic/page/examp/table/tr">
 <TR><xsl:apply-templates/></TR>
</xsl:template>

<xsl:template match="//topic/page/choose_td/table">
 <TABLE width="100%" border="{@border}"><xsl:apply-templates/></TABLE>
</xsl:template>

<xsl:template match="//topic/page/choose_td/table/tr/td_left">
 <TD align="justify" width="{@width}" id="{@id}" ></TD> 
</xsl:template>

<xsl:template match="//topic/page/choose_td/table/tr/td_middle">
 <TD align="justify" width="50%" id="{@id}"></TD> 
</xsl:template>


<xsl:template match="//topic/page/choose_td/table/tr/td_right">
 <TD align="justify" width="50%" id="{@id}"></TD> 
</xsl:template>

<xsl:template match="//topic/page/choose_td/table/tr/td_dialog">
 <TD align="justify" width="{@width}" id="{@id}" class="border_aud"></TD> 
</xsl:template>

<xsl:template match="//topic/page/choose_td/table/tr">
 <TR><xsl:apply-templates/></TR>
</xsl:template>



<xsl:template match="//topic/page/choose_td/table/tr/td/button_ok">
<TD width="58px" valign="bottom"><IMG src="../../../pic/OK.gif"   onclick="navigate('#_clickDEx1={@test_id}|{@label_id}')" hideFocus="true" onmouseover="this.src='../../../pic/OK_over.gif'" onmouseout="this.src='../../../pic/OK.gif'" onmousedown="this.src='../../../pic/OK_down.gif'" onmouseup="this.src='../../../pic/OK_over.gif'"/>  
<IMG src="../../../pic/BDGRAY.GIF" id="{@test_id}"  width="22" height="21" hideFocus="true" style="cursor: default;"/></TD>
</xsl:template>

<!--текст, таблица, большая картинка-->

<xsl:template match="//topic/page/top/table">
<TR><TD><TABLE width="100%" border="1" style="font-size:12pt; font-weight:bold;"><xsl:apply-templates/></TABLE></TD></TR>
<TR><TD height="10px"></TD></TR>
</xsl:template>

<xsl:template match="//topic/page/top/table/tr/td">
 <TD align="justify" width="{@width}" colspan="{@colspan}" rowspan="{@rowspan}"><DIV align="justify" style="text-indent: 10px;width:99%;"><xsl:apply-templates/></DIV></TD> 
</xsl:template>

<xsl:template match="//topic/page/top/table/tr">
 <TR><xsl:apply-templates/></TR>
</xsl:template>

<xsl:template match="//topic/page/top/text">
<TR><TD style="font-size:{@size};">
<xsl:apply-templates/>
</TD></TR>
</xsl:template>

<xsl:template match="//topic/page/top/image_big">
<TR>
<TD align="center" valign="top" style="padding-bottom:5px;">
<IMG  src="{/topic/page/top/image_big/@name}"   border="0"/>
</TD>
</TR>
</xsl:template>

<!--конец_текст, таблица, большая картинка-->

<xsl:template name="list_of_words">
 <xsl:param name="CurrPageNum" select="@num"/>
	<TABLE  width="100%"  cellpadding="0" cellspacing="0" border="0">
      <xsl:for-each select="//topic/page[@num=$CurrPageNum]/list_of_words">
<TR>
<TD width="100%"><xsl:apply-templates select="list"/><xsl:apply-templates select="list_multi"/>

</TD>

</TR>	     
                        
     </xsl:for-each>

</TABLE> 
</xsl:template>

<xsl:template match="list_of_words">
 <xsl:param name="CurrPageNum" select="@num"/>
	<TABLE  width="100%"  cellpadding="0" cellspacing="0" border="0">
     
<TR>
<TD width="100%"><xsl:apply-templates select="list"/><xsl:apply-templates select="list_multi"/>

</TD>

</TR>	     
                        
   

</TABLE> 
</xsl:template>

<xsl:template match="//list">
<A onClick="memory_word(this, '{@id}');" value="{@value}" id="click_{@id}"><SPAN class="examples_choose" id="list_{@id}"><xsl:value-of select="@value"/></SPAN><xsl:text> </xsl:text></A>

</xsl:template>

<xsl:template match="//list_multi">
<A onClick="memory_word_multi(this, '{@id}');" value="{@value}" id="click_{@id}"><SPAN class="examples_choose" id="list_{@id}"><xsl:value-of select="@value"/></SPAN><xsl:text> </xsl:text></A>

</xsl:template>


<xsl:template name="phrases">
 <xsl:param name="CurrPageNum" select="@num"/>
	<TABLE  width="100%"  cellpadding="0" cellspacing="0" border="0">
      <xsl:for-each select="//topic/page[@num=$CurrPageNum]/phrases">
<TR>
<TD width="100%"><xsl:apply-templates select="phrase"/></TD>

</TR>	     
                        
     </xsl:for-each>

</TABLE> 
</xsl:template>

<xsl:template match="phrases">
 <xsl:param name="CurrPageNum" select="@num"/>
	<TABLE  width="100%"  cellpadding="0" cellspacing="0" border="0">
     
<TR>
<TD width="100%"><xsl:apply-templates select="phrase"/></TD>

</TR>	     
                        
    

</TABLE> 
</xsl:template>

<xsl:template match="//page/phrases/phrase">
<A onClick="Phrases(this, '{@id}');" value="{@value}" id="phrase_link_{@id}"><SPAN class="examples" id="phrase_{@id}"><xsl:value-of select="@value"/></SPAN><xsl:text> </xsl:text></A><BR/>
</xsl:template>


</xsl:stylesheet>