﻿<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="//li">
 <LI><A onFocus="this.blur()" href="#_text={@target}"><B><xsl:apply-templates/></B></A></LI>
</xsl:template>

<xsl:template match="//li_navig">
 <LI><A onFocus="this.blur()" href="#" onclick="ShowPage_Navigator('{@pagename}','{@menuname}')"><B><xsl:apply-templates/></B></A></LI>
</xsl:template>

<xsl:template match="//unit/theory/part/first">
 <TR><TD align="justify" colspan="2"><DIV align="justify" style="text-indent: 10px;width:99%; size:12pt;"><xsl:apply-templates/></DIV></TD></TR> 
</xsl:template>

<xsl:template match="//unit/theory/part/tr/td">
 <TD align="justify" ><DIV align="justify" style="text-indent: 10px;width:99%;"><xsl:apply-templates/></DIV></TD> 
</xsl:template>

<xsl:template match="//unit/theory/part/tr">
 <TR><xsl:apply-templates/></TR>
</xsl:template>

<xsl:template match="txt_z_n">
 <SPAN CLASS="txt_z_n"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="txt_m_i">
 <SPAN CLASS="txt_m_i"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="txt_m_n">
 <SPAN CLASS="txt_m_n"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="txt_m_b">
 <SPAN CLASS="txt_m_b"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="txt_b_b">
 <SPAN CLASS="txt_b_b"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="txt_b_n">
 <SPAN CLASS="txt_b_n"><xsl:value-of select="."/></SPAN>
</xsl:template>
<xsl:template match="txt_b_i">
 <SPAN CLASS="txt_b_i"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="//h2">
 <H2><center><xsl:apply-templates/></center></H2>
</xsl:template>

<xsl:template match="//maroon">
 <SPAN class="4"><xsl:apply-templates/></SPAN> 
</xsl:template>

<xsl:template match="//tense">
 <SPAN class="4"><xsl:apply-templates/></SPAN> 
</xsl:template>

<xsl:template match="//bold">
 <SPAN class="3"><xsl:apply-templates/></SPAN> 
</xsl:template>

<xsl:template match="//unit/theory/part/ol">
 <TR><TD align="justify" colspan="2"><OL type="I"><xsl:apply-templates/></OL></TD></TR> 
</xsl:template>

<xsl:template match="//img">
<TR><TD align="center" colspan="2"><IMG src="pic/{@name}" hspace="10" vspace="10"/></TD></TR> 
</xsl:template>

<xsl:template match="//img_big">
<TR><TD align="center" colspan="2"><IMG src="pic/{@name}" id="{@id}" width="200px" /></TD></TR> 
</xsl:template>

<xsl:template match="//text()">
<SPAN style="font-family: Arial; text-align:justify"><xsl:value-of select="."/></SPAN>
</xsl:template>

<xsl:template match="//unit/theory/part/bukvi">
 <TR><TD align="center" colspan="2"><xsl:apply-templates/></TD></TR> 
</xsl:template>


<xsl:template match="//unit/theory/part/para">
 <TR><TD align="justify" colspan="2"><DIV align="justify"><xsl:apply-templates/></DIV></TD></TR> 
</xsl:template>



<xsl:template match="//unit/theory/part/para[1]">
 <TR><TD align="justify" colspan="2">
 <DIV align="justify"><SPAN style="font-family: Arial;font-weight:bold; text-align:justify"><xsl:number level="single"  format="a" count="//theory/part"/>) </SPAN>
 <xsl:apply-templates/></DIV></TD></TR> 
</xsl:template>

<xsl:template match="//unit/theory/part/example">
 <TR>
<xsl:if test="image">
 <TD align="center">
 <IMG src="pic/{image}" border="0" hspace="10" vspace="10"/>
  
</TD>
<TD>
<DIV align="justify"><B>&#8211;</B> <xsl:apply-templates/></DIV>
</TD>
</xsl:if>
<xsl:if test="not(image)">
 
<TD colspan="2">
<DIV align="justify"><B>&#8211;</B> <xsl:apply-templates/></DIV>
</TD>
</xsl:if>
</TR>

</xsl:template>

<xsl:template match="//image"/>

<xsl:template name="img">
<TR><TD align="center"><IMG src="../pic/{/topic/page/unit/image}.gif"/><BR/></TD></TR> 
</xsl:template>



<xsl:template match="//br">
<BR/>
</xsl:template>


<xsl:template match="//link">
 <A  onFocus="this.blur()" href="#_text={@target}"><B><xsl:apply-templates/></B></A>
</xsl:template>


<xsl:template match="//reallink">
 <A  onFocus="this.blur()" href="{@href}"><B><xsl:apply-templates/></B></A>
</xsl:template>

<xsl:template match="//link_navig">
 <A  onFocus="this.blur()" href="#" onclick="ShowPage_Navigator('{@pagename}','{@menuname}')"><B><xsl:apply-templates/></B></A>
</xsl:template>


<xsl:template name="Title2">
 
<xsl:param name="LANG_FOLDER" />
       <TD  align="center" valign="top" style="background-image:URL('../pic_{$LANG_FOLDER}/{/topic/page/opnfile}.gif'); background-repeat: no-repeat; background-position: center"></TD>

</xsl:template>

<xsl:template name="Title1">
 
<xsl:param name="LANG_FOLDER" />
       <TD  align="center" valign="top" style="background-image:URL('pic_{$LANG_FOLDER}/{/topic/page/opnfile}.gif'); background-repeat: no-repeat; background-position: center"></TD>

</xsl:template>



</xsl:stylesheet>