﻿<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template name="showWord">
	<xsl:param name="node"/>
	<xsl:param name="word-id"/>
               <xsl:for-each select="$node">
	 <xsl:if test="not(@color)">
                
	      <LI>
                        <xsl:if test="@pronounce">
                         <A  onFocus="this.blur()" name="{@spelling}" n="{concat(local-name(..),../@from)}"  ID="{$word-id}" class="{concat(local-name(..),../@from)}" onclick="ClickExample(this, '{@name}')"   href="#_sb={@pronounce}"><xsl:value-of select="@spelling"/></A>
                        </xsl:if>
                        <xsl:if test="not(@pronounce)">
	               <A  onFocus="this.blur()" name="{@spelling}" n="{concat(local-name(..),../@from)}"  ID="{$word-id}" class="{concat(local-name(..),../@from)}" onclick="ClickExample(this, '{@name}')"  href="#_sb={@spelling}" >
                                      <xsl:choose>
                                      <xsl:when test="starts-with(@spelling,'[')">
    			<SPAN class="phonem"><xsl:value-of select="@spelling"/></SPAN>
   		         </xsl:when>	
		         <xsl:otherwise>
			<xsl:value-of select="@spelling"/>
		         </xsl:otherwise>
		        </xsl:choose>	
	     	</A>
                        </xsl:if>
                   
                    </LI>
 	  
	  
	</xsl:if>
		<xsl:if test="@color">
                
	      <LI>
                        
                         <A  onFocus="this.blur()" name="{@spelling}" n="{concat(local-name(..),../@from)}"  ID="{$word-id}" class="{concat(local-name(..),../@from)}" onclick="ClickExample(this, '{@name}')"   href="#_sb={@pronounce}"><xsl:apply-templates/></A>
                      
                       
                       <xsl:text> </xsl:text>
                     
                    </LI>
 	  
	  
	</xsl:if>
	 </xsl:for-each>
</xsl:template>

<xsl:template name="Columns_of_Words">
 <xsl:param name="i" select="1"/>
 <xsl:param name="CurrentPage" select="/page[@num=1]"/>

 <xsl:param name="AllWords" select="$CurrentPage/examples/word|$CurrentPage/exceptions/word"/>
 <xsl:param name="ExampleColumns" select="$CurrentPage/exampleColumns"/>
 <xsl:param name="NumRows" select="ceiling((count($AllWords)+1) div $ExampleColumns)"/>

<xsl:variable name="nodes" select="$AllWords[position()&gt;=$i and position()&lt;$i+$NumRows]"/>
 <xsl:if test="$nodes">

  <TD VALIGN="top" width="{format-number(100 div $ExampleColumns,'#')}%">
  

<UL TYPE="disc">
   <xsl:for-each select="$nodes">
      <xsl:call-template name="showWord">
       <xsl:with-param name="word-id">id_word_<xsl:value-of select="$i+position()-1"/></xsl:with-param> 
       <xsl:with-param name="node" select="."/>
     </xsl:call-template>
   </xsl:for-each>
  </UL>

  </TD>

  <xsl:call-template name="Columns_of_Words">

   <xsl:with-param name="i" select="$i+$NumRows"/>
   <xsl:with-param name="CurrentPage" select="$CurrentPage"/>

   <xsl:with-param name="AllWords" select="$AllWords"/>
   <xsl:with-param name="ExampleColumns" select="$ExampleColumns"/>
   <xsl:with-param name="NumRows" select="$NumRows"/>

  </xsl:call-template>
 </xsl:if>
</xsl:template>
</xsl:stylesheet>