﻿<!DOCTYPE xsl:stylesheet >
<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="../common/identify.xsl"/>
<xsl:import href="../common/vinti.xsl"/>
<xsl:import href="../common/format_teor.xsl"/>
<xsl:import href="../common/tooltip.xsl"/>
<xsl:include  href="../common/Constructions-RU.xsl"/>


<xsl:param  name="LANG_FOLDER" select="'RU'" />



<xsl:template match="//topic/page/unit/theory/part/phonetic">

<map name="phonetic" border="0">
<area shape="poly" coords="73,71,91,74,58,108" href="javascript:nothing();" onmouseover="flipBtn('btnAlv','btnalveolar2','alveolar','{@lang}')"
                 onmouseout="flipBtn('btnAlv','btnalveolar1','organ','{@lang}')"  onFocus="this.blur()"/>
<area shape="poly" coords="100,70,140,68,172,83,180,113,130,98,60,123" href="javascript:nothing();" onmouseover="flipBtn('btnCav','btncavity2','cavity','{@lang}')"
                 onmouseout="flipBtn('btnCav','btncavity1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="poly" coords="70,1,180,5,200,67,25,58" href="javascript:nothing();" onmouseover="flipBtn('btnNcav','btnncavity2','ncavity','{@lang}')"
                 onmouseout="flipBtn('btnNcav','btnncavity1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="poly" coords="85,62,170,66,83,77" href="javascript:nothing();" onmouseover="flipBtn('btnHpal','btnhpalate2','hpalate','{@lang}')"
                 onmouseout="flipBtn('btnHpal','btnhpalate1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="poly" coords="68,75,60,125,65,170,40,130" href="javascript:nothing();" onmouseover="flipBtn('btnTeeth','btnteeth2','teeth','{@lang}')"
                 onmouseout="flipBtn('btnTeeth','btnteeth1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="rect" coords="55,150,75,185" href="javascript:nothing();" onmouseover="flipBtn('btnMand','btnmandible2','mandible','{@lang}')"
                 onmouseout="flipBtn('btnMand','btnmandible1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="rect" coords="190,225,210,235" href="javascript:nothing();" onmouseover="flipBtn('btnFolds','btnfolds2','folds','{@lang}')"
                 onmouseout="flipBtn('btnFolds','btnfolds1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="poly" coords="140,100,173,115,187,147,160,130" href="javascript:nothing();" onmouseover="flipBtn('btnTback','btntonback2','tonback','{@lang}')"
                 onmouseout="flipBtn('btnTback','btntonback1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="poly" coords="140,70,180,70,188,110,170,80" href="javascript:nothing();" onmouseover="flipBtn('btnPal','btnpalate2','palate','{@lang}')"
                 onmouseout="flipBtn('btnPal','btnpalate1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="rect" coords="27,100,45,160" href="javascript:nothing();" onmouseover="flipBtn('btnLips','btnlips2','lips','{@lang}')"
                 onmouseout="flipBtn('btnLips','btnlips1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="poly" coords="180,190,200,160,190,210" href="javascript:nothing();" onmouseover="flipBtn('btnEpigl','btnepigl2','epigl','{@lang}')"
                 onmouseout="flipBtn('btnEpigl','btnepigl1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="circle" coords="200,135,25" href="javascript:nothing();" onmouseover="flipBtn('btnPhar','btnphar2','phar','{@lang}')"
                 onmouseout="flipBtn('btnPhar','btnphar1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="rect" coords="77,110,93,130" href="javascript:nothing();" onmouseover="flipBtn('btnTblade','btntonblade2','tonblade','{@lang}')"
                 onmouseout="flipBtn('btnTblade','btntonblade1','organ','{@lang}')" onFocus="this.blur()"/>
<area shape="rect" coords="75,130,85,140" href="javascript:nothing();" onmouseover="flipBtn('btnTtip','btntontip2','tontip','{@lang}')"
                 onmouseout="flipBtn('btnTtip','btntontip1','organ','{@lang}')" onFocus="this.blur()"/>
</map>
<TR>
<TD width="10%">


<TABLE  height="100%" width="100%" cellpadding="0" cellspacing="0" border="0">
<TR>
<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnAlv','btnalveolar2','alveolar','{@lang}')"
                 onmouseout="flipBtn('btnAlv','btnalveolar1','organ','{@lang}')">
<IMG name="btnAlv" src="pic/phonetic/{@lang}/btn_alveolar_off.gif" border="0"/>
</A>
</TD>

<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnPal','btnpalate2','palate','{@lang}')"
                 onmouseout="flipBtn('btnPal','btnpalate1','organ','{@lang}')">
<IMG name="btnPal" src="pic/phonetic/{@lang}/btn_palate_off.gif" border="0"/>
</A>
</TD>
</TR>
<TR>
<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnTeeth','btnteeth2','teeth','{@lang}')"
                 onmouseout="flipBtn('btnTeeth','btnteeth1','organ','{@lang}')">
<IMG name="btnTeeth" src="pic/phonetic/{@lang}/btn_teeth_off.gif" border="0"/>
</A>
</TD>

<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnLips','btnlips2','lips','{@lang}')"
                 onmouseout="flipBtn('btnLips','btnlips1','organ','{@lang}')">
<IMG name="btnLips" src="pic/phonetic/{@lang}/btn_lips_off.gif" border="0"/>
</A>
</TD>
</TR>
<TR>
<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnCav','btncavity2','cavity','{@lang}')"
                 onmouseout="flipBtn('btnCav','btncavity1','organ','{@lang}')">
<IMG name="btnCav" src="pic/phonetic/{@lang}/btn_cavity_off.gif" border="0"/>
</A>
</TD>

<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnEpigl','btnepigl2','epigl','{@lang}')"
                 onmouseout="flipBtn('btnEpigl','btnepigl1','organ','{@lang}')">
<IMG name="btnEpigl" src="pic/phonetic/{@lang}/btn_epigl_off.gif" border="0"/>
</A>
</TD>
</TR>
<TR>
<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnFolds','btnfolds2','folds','{@lang}')"
                 onmouseout="flipBtn('btnFolds','btnfolds1','organ','{@lang}')">
<IMG name="btnFolds" src="pic/phonetic/{@lang}/btn_folds_off.gif" border="0"/>
</A>
</TD>

<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnPhar','btnphar2','phar','{@lang}')"
                 onmouseout="flipBtn('btnPhar','btnphar1','organ','{@lang}')">
<IMG name="btnPhar" src="pic/phonetic/{@lang}/btn_phar_off.gif" border="0"/>
</A>
</TD>
</TR>
<TR>
<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnNcav','btnncavity2','ncavity','{@lang}')"
                 onmouseout="flipBtn('btnNcav','btnncavity1','organ','{@lang}')">
<IMG name="btnNcav" src="pic/phonetic/{@lang}/btn_ncavity_off.gif" border="0"/>
</A>
</TD>

<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnMand','btnmandible2','mandible','{@lang}')"
                 onmouseout="flipBtn('btnMand','btnmandible1','organ','{@lang}')">
<IMG name="btnMand" src="pic/phonetic/{@lang}/btn_mandible_off.gif" border="0"/>
</A>
</TD>
</TR>
<TR>
<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnHpal','btnhpalate2','hpalate','{@lang}')"
                 onmouseout="flipBtn('btnHpal','btnhpalate1','organ','{@lang}')">
<IMG name="btnHpal" src="pic/phonetic/{@lang}/btn_hpalate_off.gif" border="0"/>
</A>
</TD>

<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnTblade','btntonblade2','tonblade','{@lang}')"
                 onmouseout="flipBtn('btnTblade','btntonblade1','organ','{@lang}')">
<IMG name="btnTblade" src="pic/phonetic/{@lang}/btn_tonblade_off.gif" border="0"/>
</A>
</TD>
</TR>
<TR>
<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnTback','btntonback2','tonback','{@lang}')"
                 onmouseout="flipBtn('btnTback','btntonback1','organ','{@lang}')">
<IMG name="btnTback" src="pic/phonetic/{@lang}/btn_tonback_off.gif" border="0"/>
</A>
</TD>

<TD>
<A onFocus="this.blur()"
                 onmouseover="flipBtn('btnTtip','btntontip2','tontip','{@lang}')"
                 onmouseout="flipBtn('btnTtip','btntontip1','organ','{@lang}')">
<IMG name="btnTtip" src="pic/phonetic/{@lang}/btn_tontip_off.gif" border="0"/>
</A>
</TD>
</TR>
</TABLE>
</TD>
<TD width="10%" align="center"><IMG src="pic/phonetic/organ.jpg" name="organ" usemap="#phonetic" border="0"/>
</TD>

</TR>
</xsl:template>

<xsl:template name="showWord_gram">
	<xsl:param name="node"/>
	<xsl:param name="word-id"/>
               <xsl:for-each select="$node">
	 <xsl:choose>
                <xsl:when test="@spelling">
	      <LI>
                        <xsl:if test="@pronounce">
                         <A NAME="{concat(local-name(..),../@from)}"  ID="{$word-id}" class="{concat(local-name(..),../@from)}" onclick="ClickExample(this)"   href="#_text={@pronounce}" hideFocus="true"><xsl:value-of select="@spelling" /></A>
                        </xsl:if>
                        <xsl:if test="not(@pronounce)">
	               <A NAME="{concat(local-name(..),../@from)}"  ID="{$word-id}" class="{concat(local-name(..),../@from)}" onclick="ClickExample(this)"   href="#_sb={@spelling}" hideFocus="true">
                                      <xsl:choose>
                                      <xsl:when test="starts-with(@spelling,'[')">
    			<SPAN class="phonem"><xsl:value-of select="@spelling"/></SPAN>
   		         </xsl:when>	
		         <xsl:otherwise>
			<xsl:value-of select="@spelling"/>
		         </xsl:otherwise>
		        </xsl:choose>	
	     	</A>
                        </xsl:if>
                       <xsl:text> </xsl:text>
                       <xsl:apply-templates/>
                    </LI>
 	  </xsl:when>	
	  <xsl:otherwise>
 	    <xsl:apply-templates/>
  	  </xsl:otherwise>
	 </xsl:choose>
	 </xsl:for-each>
</xsl:template>



 


<xsl:template name="Columns_of_Words_gram">
 <xsl:param name="i" select="1"/>
 <xsl:param name="CurrentPage" select="/page[@num=1]"/>

 <xsl:param name="AllWords" select="$CurrentPage/examples/word|$CurrentPage/exceptions/word"/>
 <xsl:param name="ExampleColumns" select="$CurrentPage/exampleColumns"/>
 <xsl:param name="NumRows" select="ceiling((count($AllWords)+1) div $ExampleColumns)"/>

<xsl:variable name="nodes" select="$AllWords[position()&gt;=$i and position()&lt;$i+$NumRows]"/>
 <xsl:if test="$nodes">
<xsl:if test="//topic/gram">
  <TD VALIGN="top" width="{format-number(100 div $ExampleColumns,'#')}%">
  <FONT color="maroon"><UL TYPE="1">
   <xsl:for-each select="$nodes">
      <xsl:call-template name="showWord_gram">
       <xsl:with-param name="word-id">id_word_<xsl:value-of select="$i+position()-1"/></xsl:with-param> 
       <xsl:with-param name="node" select="."/>
     </xsl:call-template>
   </xsl:for-each>
  </UL></FONT>
  </TD>
</xsl:if>
<xsl:if test="not(//topic/gram)">
  <TD VALIGN="top" width="{format-number(100 div $ExampleColumns,'#')}%">
  <FONT color="maroon"><UL TYPE="disc">
   <xsl:for-each select="$nodes">
      <xsl:call-template name="showWord_gram">
       <xsl:with-param name="word-id">id_word_<xsl:value-of select="$i+position()-1"/></xsl:with-param> 
       <xsl:with-param name="node" select="."/>
     </xsl:call-template>
   </xsl:for-each>
  </UL></FONT>
  </TD>
</xsl:if>
  <xsl:call-template name="Columns_of_Words_gram">

   <xsl:with-param name="i" select="$i+$NumRows"/>
   <xsl:with-param name="CurrentPage" select="$CurrentPage"/>

   <xsl:with-param name="AllWords" select="$AllWords"/>
   <xsl:with-param name="ExampleColumns" select="$ExampleColumns"/>
   <xsl:with-param name="NumRows" select="$NumRows"/>

  </xsl:call-template>
 </xsl:if>
</xsl:template>







<xsl:template match="page">
<xsl:param name="CurrPageNum" select="@num"/>


<DIV id="tooltip" style="position: absolute; top: 0px; left:0px; visibility: hidden; text-align: justify; font-size: 10pt; font-family: Arial;border: thin solid RGB(82,98,125); background-color: RGB(198,203,213); text-indent: 5px; padding: 2px;"></DIV>






<TABLE width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" id="gif">
<xsl:if test="@deep=1">
<TR height="100%">
<TD>
<TABLE width="31px" height="100%" cellpadding="0" cellspacing="0" border="0">
<TR>
<TD width="31px" align="left" valign="top"><IMG src="pic/corner_t_l.gif" border="0"/></TD>
</TR>
<TR height="100%"><TD class="bgleft" height="98%"></TD>
</TR>
<TR>
<TD width="31px" align="left" valign="bottom"><IMG src="pic/corner_b_l_teor.gif" border="0"/></TD>
</TR>
</TABLE>
</TD>


<TD width="95%">
<TABLE class="1" width="100%" height="100%" cellpadding="0" cellspacing="0" border="0">
<TR height="80px">
<TD>
<TABLE width="100%" cellpadding="0" cellspacing="0" border="0" align="justify" height="100%">
<TR>
<TD align="left" valign="top" width="50px"><xsl:call-template name="vint1_teor">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template></TD>

<TD  valign="top" width="98%"><TABLE width="100%" height="100%"   cellpadding="0" cellspacing="0" border="0">
<TR  height="38PX">
<xsl:call-template name="Title1">
	<xsl:with-param name="LANG_FOLDER" select="$LANG_FOLDER"/>
 </xsl:call-template>

</TR>
<TR height="90%">

<TD class="pis" width="100%" valign="top"><IMG src="pic/pic.gif" border="0" height="10px" width="350px"/></TD>
</TR>
</TABLE>
</TD>
<TD align="right" valign="top" width="50px"><xsl:call-template name="vint2_teor">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template></TD>
</TR>
</TABLE>
</TD>
</TR>
<TR>
<TD >
<TABLE  class="WordListTable" width="100%" height="100%" cellpadding="0" cellspacing="0" border="0">

<TR height="100%">
<TD align="center" >
<DIV id="div_width" style="width:100%; height:100%; overflow:auto; margin-left: 0px; margin-right: 0px;">
<TABLE width="100%" cellpadding="0" cellspacing="0" border="0" align="justify" height="100%">

<xsl:for-each select="unit/theory[@language=$LANG_FOLDER]/part">
 <xsl:apply-templates/>
</xsl:for-each>
</TABLE>
</DIV>
</TD>
</TR>
</TABLE>
</TD>
</TR>
<TR height="60px">
<TD>
<TABLE width="100%" cellpadding="0" cellspacing="0" border="0" align="justify" height="100%">
<TR>
<TD align="right" valign="bottom" width="50px"><xsl:call-template name="vint3_teor">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template></TD>
<TD class="pis11"  valign="top" width="98%"></TD>
<TD align="left" valign="bottom" width="50px"><xsl:call-template name="vint4_teor">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template>
</TD>
</TR>
</TABLE>
</TD>
</TR>
<TR height="20px"><TD  class="bgbottom_teor"></TD></TR>
</TABLE>
</TD>
<TD>
<TABLE width="37px" height="100%" cellpadding="0" cellspacing="0" border="0">
<TR>
<TD width="37px" align="right" valign="top"><IMG src="pic/corner_t_r.gif" border="0"/></TD>
</TR>
<TR height="100%"><TD class="bgright"></TD>
</TR>
<TR>
<TD width="37px" align="right" valign="bottom"><IMG src="pic/corner_b_r_teor.gif" border="0"/></TD>
</TR>
</TABLE>
</TD>
</TR>



</xsl:if>

<xsl:if test="@deep=2">


<TR height="100%">
<TD>
<TABLE width="31px" height="100%" cellpadding="0" cellspacing="0" border="0">
<TR>
<TD width="31px" align="left" valign="top"><IMG src="../pic/corner_t_l.gif" border="0"/></TD>
</TR>
<TR height="100%"><TD class="bgleft" height="98%"></TD>
</TR>
<TR>
<TD width="31px" align="left" valign="bottom"><IMG src="../pic/corner_b_l_teor.gif" border="0"/></TD>
</TR>
</TABLE>
</TD>


<TD width="95%">
<TABLE class="1" width="100%" height="100%" cellpadding="0" cellspacing="0" border="0">
<TR height="80px">
<TD>
<TABLE class="1" width="100%" height="100%" cellpadding="0" cellspacing="0" border="0">
<TR>
<TD align="left" valign="top" width="50px"><xsl:call-template name="vint1_teor">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template></TD>

<TD  valign="top" width="98%"><TABLE width="100%" height="100%"   cellpadding="0" cellspacing="0" border="0">
<TR  height="38PX">


<xsl:call-template name="Title2">
	<xsl:with-param name="LANG_FOLDER" select="$LANG_FOLDER"/>
 </xsl:call-template>


</TR>
<TR height="90%">

<TD class="pis" width="100%" valign="top"><IMG src="../pic/pic.gif" border="0" height="10px" width="350px"/></TD>
</TR>
</TABLE>
</TD>

<TD align="left" valign="top" width="50px"><xsl:call-template name="vint2_teor">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template></TD>

</TR>
</TABLE>
</TD>
</TR>
<TR>

<TD >
<TABLE  class="WordListTable" width="100%" height="100%" cellpadding="0" cellspacing="0" border="0">

<TR height="100%">
<TD align="center" width="100%">
<DIV id="div_width" style="width:100%; height:100%; overflow:auto; margin-left: 0px; margin-right: 0px;">
<DIV ID="oScrollMe" style="width:100%;height:100%;overflow:auto;">
<TABLE width="100%" cellpadding="0" cellspacing="0" border="0" align="justify" height="100%">
<xsl:if test="//topic/speak">
<TR>
<xsl:call-template name="Columns_of_Words_gram">
        <xsl:with-param name="CurrentPage" select="."/>
    </xsl:call-template>
</TR>
</xsl:if>
<xsl:if test="not(//topic/speak)">
<xsl:for-each select="unit/theory[@language=$LANG_FOLDER]/part">
 <xsl:apply-templates/>
</xsl:for-each>

</xsl:if>

</TABLE>
</DIV>
</DIV>
</TD>
</TR>
</TABLE>
</TD>
</TR>
<TR height="60px">
<TD>
<TABLE width="100%" cellpadding="0" cellspacing="0" border="0" align="justify" height="100%">
<TR>
<TD align="right" valign="bottom"><xsl:call-template name="vint3_teor">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template></TD>
<TD class="pis11" width="90%" valign="top"></TD>
<TD align="left" valign="bottom"><xsl:call-template name="vint4_teor">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template>

</TD>

</TR>
</TABLE>
</TD>
</TR>
<TR height="20px"><TD  class="bgbottom_teor"></TD></TR>
</TABLE>
</TD>
<TD>
<TABLE width="37px" height="100%" cellpadding="0" cellspacing="0" border="0">
<TR>
<TD width="37px" align="right" valign="top"><IMG src="../pic/corner_t_r.gif" border="0"/></TD>
</TR>
<TR height="100%"><TD class="bgright"></TD>
</TR>
<TR>
<TD width="37px" align="right" valign="bottom"><IMG src="../pic/corner_b_r_teor.gif" border="0"/></TD>
</TR>
</TABLE>
</TD>
</TR>

</xsl:if>
</TABLE>
</xsl:template>


<!-- 	~~~~~~~~~~~ 	 -->
<!-- 	 Root template	 -->
<!-- 	~~~~~~~~~~~ 	 -->

 <xsl:template match="/">
 <xsl:param name="LANG" select="RU"/>
<HTML>
<HEAD>
<xsl:if test="//topic/deep1">
<LINK REL="STYLESHEET" HREF="../common/main.css" TYPE="text/css"/>

<SCRIPT SRC="../common/main.js"/>
</xsl:if>
<xsl:if test="//topic/deep2">
<LINK REL="STYLESHEET" HREF="../../common/main.css" TYPE="text/css"/>
<SCRIPT SRC="../../common/main.js"/>
<SCRIPT SRC="../../common/organs.js"/>

</xsl:if>
</HEAD>



<xsl:if test="not(//topic/gif)">
<BODY onload="Init()" scroll="no"/>
</xsl:if>
<xsl:if test="//topic/gif">
<BODY onload="Init(), Div()" scroll="no"/>
</xsl:if>

</HTML>
 </xsl:template>



</xsl:stylesheet>



