﻿<!DOCTYPE xsl:stylesheet >
<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:import href="../common/vinti.xsl"/>
<xsl:import href="../common/zvuki.xsl"/>
<xsl:import href="../common/showword.xsl"/>
<xsl:import href="../common/pages_auto.xsl"/>
<xsl:import href="../common/format.xsl"/>
<xsl:import href="../common/sides.xsl"/>
<xsl:import href="../common/klava.xsl"/>
<xsl:include  href="../common/Constructions-RU.xsl"/>

<xsl:variable name="klava" select="/topic/klava" /> 

<xsl:param name="LANG_FOLDER" select="'RU'" />

<xsl:template name="history">
<xsl:if test="$LANG_FOLDER='RU'">
Предыстория
</xsl:if>
<xsl:if test="$LANG_FOLDER='GB'">
Prehistory
</xsl:if>
<xsl:if test="$LANG_FOLDER='SP'">
Prehistoria
</xsl:if>
<xsl:if test="$LANG_FOLDER='FR'">
Prehistoire
</xsl:if>
<xsl:if test="$LANG_FOLDER='KG'">
Тарых
</xsl:if>
<xsl:if test="$LANG_FOLDER='KZ'">
Тарих
</xsl:if>
<xsl:if test="$LANG_FOLDER='CH'">
历史
</xsl:if>
<xsl:if test="$LANG_FOLDER='DE'">
Vorgeschichte
</xsl:if>

</xsl:template>

<xsl:template name="show">
<xsl:if test="$LANG_FOLDER='RU'">
Показать
</xsl:if>
<xsl:if test="$LANG_FOLDER='GB'">
Showing
</xsl:if>
<xsl:if test="$LANG_FOLDER='SP'">
Hacer ver
</xsl:if>
<xsl:if test="$LANG_FOLDER='FR'">
Montrer
</xsl:if>
<xsl:if test="$LANG_FOLDER='KG'">
Көрсөтүү
</xsl:if>
<xsl:if test="$LANG_FOLDER='KZ'">
Көрсету
</xsl:if>
<xsl:if test="$LANG_FOLDER='CH'">
让…看
</xsl:if>
<xsl:if test="$LANG_FOLDER='DE'">
zeigen
</xsl:if>

</xsl:template>

<xsl:template name="wordform">
<xsl:if test="$LANG_FOLDER='RU'">
словоформу
</xsl:if>
<xsl:if test="$LANG_FOLDER='GB'">
wordform
</xsl:if>
<xsl:if test="$LANG_FOLDER='SP'">
forma de la palabra
</xsl:if>
<xsl:if test="$LANG_FOLDER='FR'">

</xsl:if>
<xsl:if test="$LANG_FOLDER='KG'">
Сөз
</xsl:if>
<xsl:if test="$LANG_FOLDER='KZ'">
Сөз
</xsl:if>
<xsl:if test="$LANG_FOLDER='CH'">
词
</xsl:if>
<xsl:if test="$LANG_FOLDER='DE'">
wortform
</xsl:if>

</xsl:template>

<xsl:template match="page">
<xsl:param name="CurrPageNum" select="@num"/>




<DIV id="tooltip" style="position: absolute; top: 0px; left:0px; visibility: hidden; text-align: justify; font-size: 10pt; font-family: Arial;border: thin solid RGB(82,98,125); background-color: RGB(152,207,247); text-indent: 5px; padding: 2px;"></DIV>

<TABLE width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" >
<TR height="100%">
<TD width="50px">
<xsl:call-template name="left">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template>
</TD>


<TD width="95%">
<TABLE class="1" width="100%" height="100%" cellpadding="0" cellspacing="0" border="0">

<xsl:call-template name="top">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template>

<TR>
<TD height="100%">


<TABLE  class="WordListTable" width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" id="height_page">
<TR height="50px">
<TD VALIGN="middle" ALIGN="center"   style="padding-top: 2px;padding-bottom:2px;line-height:1.3;">
<SPAN style="font-size:0.8em; font-weight:bold;"><b><xsl:apply-templates select="num"/></b><p/>   
<xsl:apply-templates select="description[@language=$LANG_FOLDER]"/></SPAN>
  </TD>
</TR>

<xsl:if test="//topic/page[@num=$CurrPageNum]/top">
<TR >
<TD id="top_table_td">
</TD>
</TR>
</xsl:if>


<TR height="10%" id="stranitsa">
<TD >


<TABLE   width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" >

<!--Слушайте и повторяйте (список фраз, органы, статическая картинка, меняющаяся картинка-->

<xsl:if test="//topic/page[@num=$CurrPageNum]/listen">

<TR HEIGHT="100%">

<TD align="center" height="100%">

<DIV ID="oScrollMe" style="width:100%;height:100%;overflow:auto; ">
<TABLE width="100%" height="100%" cellpadding="0" cellspacing="0" border="0">
<TR>
    <xsl:call-template name="Columns_of_Words">
        <xsl:with-param name="CurrentPage" select="."/>
    </xsl:call-template>
</TR>
</TABLE>
</DIV>

</TD>

	<!--Органы-->

<xsl:if test="//topic/page[@num=$CurrPageNum]/organs">
<TD width="200px" valign="top">

<xsl:call-template name="imageSound">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template>

</TD>
</xsl:if>

	<!--конец_Органы-->

	<!--Меняющаяся картинка-->

<xsl:if test="//topic/page[@num=$CurrPageNum]/image_change">
<TD width="200px" valign="top" style="padding-top:5px;">

<xsl:call-template name="imagePic_change">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template>

</TD>
</xsl:if>

	<!--конец_Меняющаяся картинка-->

	<!--Статическая картинка-->

<xsl:if test="//topic/page[@num=$CurrPageNum]/image">
<TD width="200px" valign="top" style="padding-top:5px;">

<xsl:call-template name="imagePic">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template>

</TD>
</xsl:if>

	<!--конец_Статическая картинка-->

  </TR>

</xsl:if>

<!--конец_Слушайте и повторяйте (список фраз, органы, статическая картинка, меняющаяся картинка-->

<!--Слушай и выбери, Заполните таблицу, Выберите верное предложение, Составьте диалог-->

<xsl:if test="not(//topic/page[@num=$CurrPageNum]/listen) and not(//topic/page[@num=$CurrPageNum]/blocks) and not(//topic/page[@num=$CurrPageNum]/dictant) and not(//topic/page[@num=$CurrPageNum]/multi-multi)">

<!--Таблица для заполнения-->
<xsl:if test="//topic/page[@num=$CurrPageNum]/choose_table">
<TR>
<TD id="choose_table">
<xsl:for-each select="//topic/page[@num=$CurrPageNum]/choose_td">
 <xsl:apply-templates/>
</xsl:for-each>
</TD>
</TR>
</xsl:if>
<!--конец_Таблица для заполнения-->

<TR height="100%">
<TD>
<DIV ID="oScrollMe" style="width:100%;height:100%;overflow:auto; ">

<!--Слушай и выбери-->

<xsl:if test="//topic/page[@num=$CurrPageNum]/choose">
<TABLE width="100%" height="100%" border="0">
<TR>
<TD id="choose_block">
    <xsl:call-template name="ChooseWord">
        <xsl:with-param name="CurrPageNum" select="@num"/>
    </xsl:call-template>
</TD>
</TR>
</TABLE>
</xsl:if>

<!--конец_Слушай и выбери-->

<!--Заполните таблицу-->

<xsl:if test="//topic/page[@num=$CurrPageNum]/choose_table_list">
<TABLE width="100%" height="100%" border="0">
<TR>
<TD id="table_words" valign="top">
    <xsl:call-template name="ChooseWord_Table">
        <xsl:with-param name="CurrPageNum" select="@num"/>
    </xsl:call-template>
</TD>
</TR>
</TABLE>
</xsl:if>

<!--конец_Заполните таблицу-->

<!--Выберите верное предложение-->

<xsl:if test="//topic/page[@num=$CurrPageNum]/chooseCorrPhrase">
<TABLE width="100%" height="100%" border="0">
<TR>
<TD id="corrPhrase" valign="top">
    <xsl:call-template name="ChooseCorrPhrase">
        <xsl:with-param name="CurrPageNum" select="@num"/>
    </xsl:call-template>
</TD>
</TR>
</TABLE>
</xsl:if>

<!--конец_Выберите верное предложение-->

<!--Составьте диалог-->

<xsl:if test="//topic/page[@num=$CurrPageNum]/phrases">
<TABLE  width="100%"  cellpadding="0" cellspacing="0" border="0">
<TR height="100%">
<TD id="list_phrases">
<xsl:call-template name="phrases">
        <xsl:with-param name="CurrPageNum" select="@num"/>
    </xsl:call-template>
</TD>
</TR>
</TABLE>
</xsl:if>

<!--конец_Составьте диалог-->

<!--Собери предложение (в нескольких полях)-->

<xsl:if test="//topic/page[@num=$CurrPageNum]/choose_table_multiline">
<TABLE  width="100%"  height="100%" cellpadding="0" cellspacing="0" border="0" >
<TR height="100%">
<TD id="multifield">
<TABLE  width="100%"  height="100%" cellpadding="5" cellspacing="5" border="0" >
<xsl:for-each select="//page[@num=$CurrPageNum]/choose_table_multiline/multiline">
<TR>
<TD class="border_aud" id="c_{@field_id}">
<TABLE  width="100%"  height="100%" cellpadding="0" cellspacing="0" border="0" >
<xsl:for-each select="./choose_td">
<TR>
<TD >
<xsl:apply-templates/>
</TD>
</TR>
</xsl:for-each>
<xsl:for-each select="./phrases">
<TR>
<TD>
<TABLE  width="100%"  cellpadding="0" cellspacing="0" border="0">
<TR>
<TD width="100%" style="line-height: 1.5" ><DIV align="justify"><xsl:apply-templates select="phrase"/></DIV></TD>
</TR>	     
</TABLE> 
</TD>
</TR>

</xsl:for-each>
</TABLE>
</TD>
</TR>
</xsl:for-each>
</TABLE>
</TD>
</TR>
</TABLE>
</xsl:if>

<!--конец_Собери предложение (в нескольких полях)-->


<!--Чек-боксы-->

<xsl:if test="//topic/page[@num=$CurrPageNum]/check_boxes">
<TABLE  width="100%"  height="100%" cellpadding="0" cellspacing="0" border="0" >
<TR height="100%">
<TD id="check">
<TABLE   width="100%"  cellpadding="0" cellspacing="5" border="0" >
<xsl:for-each select="//topic/page[@num=$CurrPageNum]/check">
<TR>
<TD class="border_aud">
<TABLE   width="100%" height="100%" cellpadding="2" cellspacing="0" border="0" >
<TR>
<xsl:if test="@pronounce">
<TD>
<IMG src="../../../pic/din_off.gif"  onMouseOver="this.src='../../../pic/din_over.gif'" onMouseOut="this.src='../../../pic/din_off.gif'" border="0"  onclick="navigate('#_sb={@pronounce}')"/>
</TD>
</xsl:if>

<TD>
<input type="checkbox" id="list_td_{@id}" onFocus="this.blur();" name="test_word"/>
</TD>
<TD width="99%">
<xsl:for-each select="./word">
<SPAN class="examples_choose">
<xsl:apply-templates />
</SPAN>
</xsl:for-each>
</TD>
</TR>
</TABLE>
</TD> 
</TR>
</xsl:for-each>
<TR>
<TD align="center">
<IMG src="../../../pic/OK.gif"  onclick="Gotovo_checkbox();" hideFocus="true" onmouseover="this.src='../../../pic/OK_over.gif'" onmouseout="this.src='../../../pic/OK.gif'" onmousedown="this.src='../../../pic/OK_down.gif'" onmouseup="this.src='../../../pic/OK_over.gif'"/>  
<IMG src="../../../pic/BDGRAY.GIF" id="Test" name="ok_marker"  width="22" height="21" hideFocus="true" style="cursor: default;"/>
</TD>
</TR>
</TABLE>
</TD>
</TR>
</TABLE>





</xsl:if>

<!--***************-->


</DIV>
</TD>
</TR>
</xsl:if>

<!--конец_Слушай и выбери, Заполните таблицу, Выберите верное предложение, Составьте диалог-->

<!--Составьте по образцу, Вставьте нужное слово, Вставьте реплики в диалог, Мультивыбор -->
<xsl:if test="//topic/page[@num=$CurrPageNum]/blocks">


<!--Список фраз для вставки -->

<xsl:if test="//topic/page[@num=$CurrPageNum]/list_of_words">
<TR>
<TD id="l_words" bgcolor="RGB(152,207,247)">
<xsl:call-template name="list_of_words">
        <xsl:with-param name="CurrPageNum" select="@num"/>
    </xsl:call-template>
</TD>
</TR>
</xsl:if>

<!--конец_Список фраз для вставки -->

<TR height="100%">
<TD align="center" width="100%" height="100%">

<TABLE  cellpadding="5" cellspacing="0" border="0" align="center" width="100%" height="100%">

<!--Образец выполнения -->

<xsl:if test="//topic/page[@num=$CurrPageNum]/example">
<TR height="1px"><TD valign="top">
<TABLE  cellpadding="3" cellspacing="0" border="0" align="center" class="border_exm" width="100%">

<xsl:for-each select="//page[@num=$CurrPageNum]/example">
 <xsl:apply-templates/>
</xsl:for-each>
</TABLE>
</TD></TR>
</xsl:if>

<!--конец_Образец выполнения -->

<!--Блоки -->

<TR height="100%" id="stranitsa_main">
<TD valign="top" >
<DIV style="width:100%; height:100%; overflow:auto;">
<TABLE  width="100%" cellpadding="3" cellspacing="0" border="0" align="center" >
<xsl:for-each select="//page[@num=$CurrPageNum]/block">
<TR align="center">
<xsl:if test="count(//page[@num=$CurrPageNum]/block)&gt;1">
<TD valign="top" align="left" width="5%"> 
<SPAN style="font-family: Arial;font-weight:bold; color: maroon; "><xsl:number level="single"  format="1" count="//page[@num=$CurrPageNum]/block"/>) </SPAN>
</TD>
</xsl:if>
<TD >
<TABLE  width="100%" cellpadding="3" cellspacing="0" border="0" align="center" class="border_aud">

 <xsl:apply-templates/>

</TABLE>
</TD>
</TR>
</xsl:for-each>
<xsl:if test="//topic/page[@num=$CurrPageNum]/textarea">
<xsl:for-each select="//page[@num=$CurrPageNum]/textarea">
<TR>
<TD align="center">
<TEXTAREA rows="{@rows}" cols="{@cols}" id="textarea"></TEXTAREA>
</TD>
</TR>
</xsl:for-each>
</xsl:if>
</TABLE>
</DIV>








</TD>
</TR>

<!--конец_Блоки -->


</TABLE>

</TD>
</TR>





<!--конец_Блоки -->







</xsl:if>




<xsl:if test="//topic/page[@num=$CurrPageNum]/multi-multi">

<TR height="100%">
<TD height="100%">
<TABLE cellpadding="0" cellspacing="0" border="0" align="center" height="100%" width="100%">



<!--Образец выполнения -->

<xsl:if test="//topic/page[@num=$CurrPageNum]/example">
<TR height="10px"><TD valign="top">
<TABLE  cellpadding="3" cellspacing="0" border="0" align="center" class="border_exm" width="100%">

<TR><TD align="left" ><FONT color="maroon"><B></B></FONT></TD></TR>

<xsl:for-each select="//page[@num=$CurrPageNum]/example">
 <xsl:apply-templates/>
</xsl:for-each>
</TABLE>
</TD></TR>
</xsl:if>

<!--конец_Образец выполнения -->

<!--Блоки -->

<TR id="block_height" height="100%">
<TD valign="top" >

<!--Мультивыбор (в нескольких полях)-->

<DIV style="width:100%; height:100%; overflow:auto;">
<TABLE  width="100%"  height="100%" cellpadding="0" cellspacing="0" border="0" >
<TR height="100%">
<TD id="multifield">
<TABLE  width="100%"  height="100%" cellpadding="5" cellspacing="5" border="0" >
<xsl:for-each select="//page[@num=$CurrPageNum]/multi-multi/multiblock">
<TR>
<TD>
<TABLE  width="100%"  height="100%" cellpadding="0" cellspacing="0" border="0" >
<xsl:for-each select="./list_of_words">
<TR height="2%">
<TD bgcolor="RGB(152,207,247)">
<TABLE  width="100%"  cellpadding="0" cellspacing="0" border="0">
     <TR>
<TD width="100%" align="center" style="line-height: 1.5"><xsl:apply-templates select="list"/><xsl:apply-templates select="list_multi"/>
</TD>
</TR>	     
</TABLE> 
</TD>
</TR>
</xsl:for-each>

<TR>
<TD>
<TABLE  width="100%" cellpadding="3" cellspacing="0" border="0" align="center" >
<xsl:for-each select="./block">
<TR align="center">

<TD valign="top" align="left" width="5%"> 
<SPAN style="font-family: Arial;font-weight:bold; color: maroon; "><xsl:value-of select="@num"/></SPAN>
</TD>

<TD >
<TABLE  width="100%" cellpadding="3" cellspacing="0" border="0" align="center" class="border_aud">

 <xsl:apply-templates/>

</TABLE>
</TD>
</TR>
</xsl:for-each>

</TABLE>

</TD>
</TR>


</TABLE>
</TD>
</TR>
</xsl:for-each>
</TABLE>

</TD>
</TR>
</TABLE>
</DIV>

<!--конец_Мультивыбор (в нескольких полях)-->

</TD>
</TR>
</TABLE>
</TD>
</TR>
</xsl:if>

<!--конец_Составьте по образцу, Вставьте нужное слово, Вставьте реплики в диалог, Мультивыбор -->

<!--Диктант-->

<xsl:if test="//topic/page[@num=$CurrPageNum]/dictant">
<TR height="10%">
<TD >
<TABLE width="100%" height="100%" cellpadding="0" cellspacing="5" border="0" >
<TR>
<TD width="45%"  class="border_aud">
<TABLE width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" style="padding-right:5px; padding-left:5px;">
<TR>
<TD  class="4" align="center" valign="top">
<FONT ><xsl:call-template name="history">
	<xsl:with-param name="CurrPageNum" select="@num"/>
</xsl:call-template>:</FONT>
</TD>
</TR>
<TR>
<TD id="history_dict">

</TD>
</TR>

</TABLE>
</TD>
<TD width="55%" class="border_aud">
<TABLE width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" >

<TR>
<TD  align="center" valign="top" class="4" style="font-size: 12pt; font-color: maroon;" ><B><xsl:call-template name="show">
	<xsl:with-param name="CurrPageNum" select="@num"/>
</xsl:call-template><BR/> <image src="../../../pic/marker_dict_off.GIF" id="marker2" />&#160;<A href="#_promptdict" onFocus="this.blur()" onMouseover="d.all['marker2'].src='../../../pic/marker.gif'" onMouseout="d.all['marker2'].src='../../../pic/marker_dict_off.gif'"><xsl:call-template name="wordform">
	<xsl:with-param name="CurrPageNum" select="@num"/>
</xsl:call-template>:</A></B>
</TD>
</TR>
<TR>
<TD align="center" valign="middle">
<input type="text" size="35%" id="PROMPT"/> 
</TD>
</TR>
</TABLE>
</TD>
</TR>
</TABLE>
</TD>
</TR>

<TR >
<TD align="center" valign="middle">

<TABLE cellpadding="3" cellspacing="0" border="0" class="border_aud">
<TR>
<TD align="center">
<TABLE cellpadding="0" cellspacing="0" border="0" >
<TR>
<TD>
<A  onFocus="this.blur()" href="#_playdict" width="52px"><IMG  src="../../../pic/dinamic_off1.gif" border="0" onmouseover="this.src='../../../pic/dinamic_over.gif'" onmouseout="this.src='../../../pic/dinamic_off1.gif'" onmousedown="this.src='../../../pic/dinamic_over.gif'"/></A>
</TD>
<xsl:if test="//topic/page[@num=$CurrPageNum]/next">
<TD>
<A  onFocus="this.blur()" href="#_nextdict" width="52px"><IMG  src="../../../pic/next_dict_off.gif" border="0" onmouseover="this.src='../../../pic/next_dict_over.gif'" onmouseout="this.src='../../../pic/next_dict_off.gif'" onmousedown="this.src='../../../pic/next_dict_over.gif'"/></A>
</TD>
</xsl:if>
</TR>
</TABLE>
</TD>
</TR>

<TR>
<TD>
<input type="text" size="100%" id="EDICT" onKeyDown="onKeyPress(event);"/>&#160; 
</TD>
</TR>
<TR>
<TD align="center">
<input type="image" src="../../../pic/OK.gif" id="BOK" onclick="self.navigate('#_clickdict1')" hideFocus="true" onmouseover="this.src='../../../pic/OK_over.gif'" onmouseout="this.src='../../../pic/OK.gif'" onmousedown="this.src='../../../pic/OK_down.gif'" onmouseup="this.src='../../../pic/OK_over.gif'"/> 
<img src="../../../pic/BDGRAY.GIF" id="DictID" width="22" height="21"/> 
</TD>


</TR>
</TABLE>
</TD>
</TR>


<TR valign="middle" height="100%">

<TD align="center" valign="middle"   >
<xsl:call-template name="klava">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template>
</TD>
</TR>

</xsl:if>

<!--конец_Диктант-->

</TABLE>


</TD>
</TR>



</TABLE>


</TD>
</TR>



<xsl:call-template name="bottom">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template>

<xsl:if test="//topic/page[@num=$CurrPageNum]/sounds_frame">
<TR height="20px"><TD  class="bgbottom"></TD></TR>
</xsl:if>
<xsl:if test="not(//topic/page[@num=$CurrPageNum]/sounds_frame)">
<TR height="20px"><TD  class="bgbottom_teor"></TD></TR>
</xsl:if>
	</TABLE>
</TD>

<TD>
<xsl:call-template name="right">
	<xsl:with-param name="CurrPageNum" select="@num"/>
 </xsl:call-template>
</TD>
</TR>

</TABLE>
</xsl:template>





<!-- 	~~~~~~~~~~~ 	 -->
<!-- 	 Root template	 -->
<!-- 	~~~~~~~~~~~ 	 -->

 <xsl:template match="/">
 <xsl:param name="LANG" select="RU"/>
<HTML>
<HEAD>
<LINK REL="STYLESHEET" HREF="../../../../common/main.css" TYPE="text/css"/>
<SCRIPT SRC="../../../../common/main.js"/>
</HEAD>

<BODY onload="InitPron()" onMouseDown="context_menu(event);" SCROLL="no">

</BODY>
</HTML>
 </xsl:template>



</xsl:stylesheet>




